<?php
/*
 * @ https://hospedagem.matrixch.store 
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 17/06/2024
*/

include "includes/header.php";
$table_name = "users";
$res = $db->select($table_name, "*", "", "");

if (isset($_POST["submit"])) {
    unset($_POST["submit"]);
    $updateData = $_POST;
    $db->update($table_name, $updateData, "id = :id", [":id" => 1]);
    session_regenerate_id();
    $_SESSION["loggedin"] = true;
    $_SESSION["name"] = $_POST["username"];
    echo "<script>window.location.href='" . basename($_SERVER["SCRIPT_NAME"]) . "?status=5'</script>";
    exit();
}
?>

<style>
/* Main Colors - Dark Blue Theme */
:root {
    --primary-blue: #1a237e;
    --dark-blue: #0d1541;
    --accent-blue: #3d5afe;
    --light-blue: #e8eaf6;
    --danger-red: #dc3545;
    --success-green: #28a745;
    --warning-orange: #fd7e14;
    --white: #ffffff;
    --light-gray: #f8f9fa;
    --medium-gray: #e9ecef;
    --dark-gray: #6c757d;
    --black: #212529;
}

/* Card Styles - White with Blue Accents */
.card {
    border: none;
    border-radius: 8px;
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
    margin-bottom: 20px;
    background-color: var(--white);
    border: 1px solid var(--light-blue);
}

.card-header {
    border-radius: 8px 8px 0 0 !important;
    padding: 15px 20px;
    font-weight: 600;
    color: var(--white);
    background: linear-gradient(135deg, var(--primary-blue) 0%, var(--dark-blue) 100%) !important;
}

.card-body {
    padding: 25px;
    background-color: var(--white);
}

/* Form Styles */
.form-control {
    padding: 10px 15px;
    border-radius: 6px;
    border: 1px solid var(--medium-gray);
    transition: all 0.3s;
    background-color: var(--white);
}

.form-control:focus {
    border-color: var(--accent-blue);
    box-shadow: 0 0 0 0.25rem rgba(61, 90, 254, 0.15);
}

.form-label {
    font-weight: 500;
    margin-bottom: 8px;
    color: var(--dark-blue);
}

/* Button Styles */
.btn {
    padding: 8px 16px;
    border-radius: 6px;
    font-weight: 500;
    transition: all 0.3s;
    display: inline-flex;
    align-items: center;
    justify-content: center;
}

.btn-primary {
    background-color: var(--primary-blue);
    border-color: var(--primary-blue);
    color: var(--white);
}

.btn-primary:hover {
    background-color: var(--dark-blue);
    border-color: var(--dark-blue);
}

.btn-info {
    background-color: var(--accent-blue);
    border-color: var(--accent-blue);
    color: var(--white);
}

.btn-info:hover {
    background-color: #2a4af5;
    border-color: #2a4af5;
}

.alert-warning {
    background-color: rgba(253, 126, 20, 0.1);
    border-color: rgba(253, 126, 20, 0.2);
    color: var(--warning-orange);
}

/* Responsive Adjustments */
@media (max-width: 768px) {
    .card-body {
        padding: 15px;
    }
}
</style>

<div class="container-fluid py-4">
    <?php if (isset($_GET['status'])): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            Credenciais atualizadas com sucesso!
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <div class="row">
        <div class="col-md-8 mx-auto">
            <div class="card shadow-sm">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h4 class="mb-0"><i class="fas fa-user-cog me-2"></i>Atualizar Credenciais</h4>
                    </div>
                </div>
                <div class="card-body">
                    <div class="alert alert-warning mb-4">
                        <div class="d-flex align-items-center">
                            <i class="fas fa-exclamation-triangle me-2"></i>
                            <div>
                                <strong>Importante:</strong> Não use "admin" como nome de usuário ou senha!
                            </div>
                        </div>
                    </div>

                    <form method="post">
                        <div class="mb-3">
                            <label for="username" class="form-label">Nome de Usuário</label>
                            <input type="text" class="form-control" id="username" name="username" value="<?= htmlspecialchars($res[0]["username"]) ?>" required>
                        </div>

                        <div class="mb-4">
                            <label for="password" class="form-label">Senha</label>
                            <input type="text" class="form-control" id="password" name="password" value="<?= htmlspecialchars($res[0]["password"]) ?>" required>
                        </div>

                        <div class="text-center mt-4">
                            <button type="submit" name="submit" class="btn btn-info px-4">
                                <i class="fas fa-save me-2"></i>Atualizar Credenciais
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    // Fechar alertas automaticamente
    $('.alert').delay(3000).fadeOut('slow');
});
</script>

<?php 
include "includes/footer.php";
?>