<?php
$url = "https://api.tropa.click/sport/XJ14kAtnb.json";

// Faz a requisição
$response = file_get_contents($url);

// Verifica se a requisição foi bem-sucedida
if ($response !== false) {
    // Decodifica o JSON para um array PHP
    $data = json_decode($response, true);
    
    // Verifica se a decodificação foi bem-sucedida
    if ($data !== null) {
        // Codifica de volta para JSON com formatação bonita
        $prettyJson = json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
        
        // Salva o conteúdo formatado no arquivo retorno.json
        file_put_contents("retorno.json", $prettyJson);
        echo "Dados salvos em retorno.json com sucesso e formatados.";
    } else {
        echo "Erro ao decodificar o JSON da API.";
    }
} else {
    echo "Erro ao acessar a API.";
}
?>