document.addEventListener('DOMContentLoaded', function() {
    // Efeito de hover nos cards
    const gameCards = document.querySelectorAll('.game-card');
    
    gameCards.forEach(card => {
        card.addEventListener('mouseenter', function() {
            this.style.transform = 'translateY(-5px)';
            this.style.boxShadow = '0 10px 20px rgba(0, 0, 0, 0.15)';
        });
        
        card.addEventListener('mouseleave', function() {
            this.style.transform = '';
            this.style.boxShadow = '';
        });
    });
    
    // Atualizar o status em tempo real (simulação)
    setInterval(() => {
        const statusElements = document.querySelectorAll('.game-status');
        
        statusElements.forEach(element => {
            if (element.textContent.includes('AO VIVO')) {
                element.classList.add('ao-vivo');
            } else if (element.textContent.includes('FIM')) {
                element.classList.add('fim-de-jogo');
            }
        });
    }, 1000);
});