    

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Jogos ao Vivo</title>
     <script>
        // Executa silenciosamente o salvar_jogos.php em segundo plano
        window.addEventListener('DOMContentLoaded', function() {
            fetch('salvar_jogos.php')
                .catch(error => {}); // Ignora completamente qualquer erro
        });
    </script>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        :root {
            --primary-color: #d73920;
            --secondary-color: #d73920;
            --accent-color: #5fad47;
            --text-color: #102457;
            --background-color: #1a202c;
            --card-background-color: #ffffff; /* NOVO: Variável para a cor de fundo do card */
            --card-background-rgb: 255, 255, 255; /* NOVO: RGB para a cor de fundo do card */
        }
        
        body {
            background-color: var(--background-color);
            background-image: url('uploads/backgrounds/bg_683cc6d1475cd_1000495534.jpg');background-size: cover;background-attachment: fixed;background-position: center;
            color: var(--text-color);
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            padding: 20px 0;
        }
        
        .game-card {
            border-radius: 10px;
            overflow: hidden;
            margin-bottom: 25px;
            transition: all 0.3s ease;
            background-color: var(--card-background-color); box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        }
        
        .game-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 12px 15px;
            background-color: var(--primary-color);
            color: white;
        }
        
        .competition-info {
            display: flex;
            align-items: center;
        }
        
        .competition-info img {
            height: 30px;
            margin-right: 10px;
        }
        
        .game-teams {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 20px;
            background-color: var(--card-background-color); /* Usar a nova variável aqui */
            color: var(--text-color); /* Garante que o texto dentro de game-teams siga a cor de texto geral */
        }
        
        .team {
            flex: 1;
            text-align: center;
        }
        
        .team img {
            max-height: 80px;
            margin-bottom: 10px;
        }
        
        .game-score {
    flex: 1;
    font-size: 1.8rem;
    font-weight: bold;
    text-align: center; /* Adicione esta linha */
}
        
        .game-info {
            padding: 15px;
            background-color: rgba(var(--card-background-rgb), 0.8); /* Fundo um pouco transparente para o info */
            border-top: 1px solid rgba(var(--card-background-rgb), 0.2); /* Borda superior para contraste */
            color: var(--text-color);
        }
        
        .channels-title {
            display: flex;
            align-items: center;
            margin-bottom: 10px;
        }
        
        .channels-list {
            margin-top: 10px;
        }
        
        .channel {
            display: flex;
            align-items: center;
            margin-bottom: 8px;
        }
        
        .channel img {
            width: 30px;
            margin-right: 10px;
        }
        
        
        .table-custom thead th {
            background-color: var(--primary-color);
            color: white;
            border-bottom: 2px solid var(--secondary-color);
        }
        
        .table-custom tbody tr:hover {
            background-color: rgba(var(--secondary-color-rgb), 0.1);
        }
        
        
    </style>
</head>
<body>
    <div class="container">
        <h1 class="text-center mb-5">Jogos ao Vivo</h1>
        
        <?php if ($display_type === 'table'): ?>
        <div class="table-responsive table-custom shadow-sm">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Competição</th>
                        <th>Time Casa</th>
                        <th>Placar</th>
                        <th>Time Visitante</th>
                        <th>Data/Hora</th>
                        <th>Canais</th>
                    </tr>
                </thead>
                <tbody>
                    
                    <?php foreach ($games as $game): ?>
                    <tr>
                        <td>
                            <div class="d-flex align-items-center">
                                <img src="<?= $game['img_competicao_url'] ?>" height="30" class="me-2">
                                <?= $game['competicao'] ?>
                            </div>
                        </td>
                        <td>
                            <div class="d-flex align-items-center">
                                <img src="<?= $game['img_time1_url'] ?>" height="30" class="me-2">
                                <?= $game['time1'] ?>
                            </div>
                        </td>
                        <td>
                            <strong><?= $game['placar_time1'] ?> - <?= $game['placar_time2'] ?></strong>
                        </td>
                        <td>
                            <div class="d-flex align-items-center">
                                <img src="<?= $game['img_time2_url'] ?>" height="30" class="me-2">
                                <?= $game['time2'] ?>
                            </div>
                        </td>
                        <td>
                            <?= $game['data_jogo'] ?> • <?= $game['horario'] ?>
                        </td>
                        <td>
                            <?php foreach ($game['canais'] as $channel): ?>
                            <div class="channel mb-1">
                                <img src="<?= $channel['img_url'] ?>" width="20" class="me-1">
                                <?= $channel['nome'] ?>
                            </div>
                            <?php endforeach; ?>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
        <?php else: ?>
        <div class="row">
            <?php
            $json = file_get_contents('retorno.json');
            $games = json_decode($json, true);
            
            foreach ($games as $game): ?>
            <div class="col-md-6 col-lg-4">
                <div class="game-card">
                    <div class="game-header">
                        <div class="competition-info">
                            <img src="<?= $game['img_competicao_url'] ?>" alt="<?= $game['competicao'] ?>">
                            <span><?= $game['competicao'] ?></span>
                        </div>
                        <span class="badge" style="background-color: var(--accent-color);">
                            <?= $game['status'] ?>
                        </span>
                    </div>
                    
                    <div class="game-teams">
                        <div class="team">
                            <img src="<?= $game['img_time1_url'] ?>" alt="<?= $game['time1'] ?>">
                            <h5><?= $game['time1'] ?></h5>
                        </div>
                        
                        <div class="game-score">
                            <?= $game['placar_time1'] ?> - <?= $game['placar_time2'] ?>
                        </div>
                        
                        <div class="team">
                            <img src="<?= $game['img_time2_url'] ?>" alt="<?= $game['time2'] ?>">
                            <h5><?= $game['time2'] ?></h5>
                        </div>
                    </div>
                    
                    <div class="game-info">
                        <div class="game-date">
                            <i class="far fa-calendar-alt"></i>
                            <span><?= $game['data_jogo'] ?> • <?= $game['horario'] ?></span>
                        </div>
                        
                        <div class="game-channels">
                            <h6 class="channels-title">
                                
                                Canais de Transmissão:
                            </h6>
                            <div class="channels-list">
                                <?php foreach ($game['canais'] as $channel): ?>
                                <div class="channel">
                                    <img src="<?= $channel['img_url'] ?>" alt="<?= $channel['nome'] ?>">
                                    <span><?= $channel['nome'] ?></span>
                                </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
        <?php endif; ?>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>