<?php
// Configurações iniciais
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Diretórios para uploads
$uploadDirs = [
    'logos' => 'uploads/logos/',
    'backgrounds' => 'uploads/backgrounds/'
];

foreach ($uploadDirs as $dir) {
    if (!file_exists($dir)) {
        mkdir($dir, 0755, true);
    }
}

// Alternativa para mime_content_type()
if (!function_exists('mime_content_type')) {
    function mime_content_type($filename) {
        $mime_types = [
            'png' => 'image/png',
            'jpe' => 'image/jpeg',
            'jpeg' => 'image/jpeg',
            'jpg' => 'image/jpeg',
            'gif' => 'image/gif',
            'svg' => 'image/svg+xml',
        ];
        
        $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
        return $mime_types[$ext] ?? 'application/octet-stream';
    }
}

// Processar formulário se enviado
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Configurações básicas
    $config = [
        'display_type' => $_POST['display_type'] ?? 'cards',
        'card_style' => $_POST['card_style'] ?? 'default',
        'colors' => [
            'primary' => $_POST['primary_color'] ?? '#10b981',
            'secondary' => $_POST['secondary_color'] ?? '#3b82f6',
            'accent' => $_POST['accent_color'] ?? '#ef4444',
            'text' => $_POST['text_color'] ?? '#e2e8f0',
            'background' => $_POST['background_color'] ?? '#1a202c',
            'card_background' => $_POST['card_background_color'] ?? '#ffffff' // NOVO: Cor de fundo do card
        ],
        'neon_effect' => isset($_POST['neon_effect']),
        'channel_logo' => '',
        'background_image' => ''
    ];

    // Processar upload do logo
    if (isset($_FILES['channel_logo']) && $_FILES['channel_logo']['error'] === UPLOAD_ERR_OK) {
        $allowedTypes = ['image/png', 'image/jpeg', 'image/gif', 'image/svg+xml'];
        $fileExt = strtolower(pathinfo($_FILES['channel_logo']['name'], PATHINFO_EXTENSION));
        $allowedExtensions = ['png', 'jpg', 'jpeg', 'gif', 'svg'];
        
        if (in_array($fileExt, $allowedExtensions)) {
            $filename = uniqid('logo_') . '_' . basename($_FILES['channel_logo']['name']);
            $destination = $uploadDirs['logos'] . $filename;
            
            if (move_uploaded_file($_FILES['channel_logo']['tmp_name'], $destination)) {
                $config['channel_logo'] = $filename;
            }
        }
    }

    // Processar upload do background
    if (isset($_FILES['background_image']) && $_FILES['background_image']['error'] === UPLOAD_ERR_OK) {
        $allowedTypes = ['image/png', 'image/jpeg', 'image/gif'];
        $fileExt = strtolower(pathinfo($_FILES['background_image']['name'], PATHINFO_EXTENSION));
        $allowedExtensions = ['png', 'jpg', 'jpeg', 'gif'];
        
        if (in_array($fileExt, $allowedExtensions)) {
            $filename = uniqid('bg_') . '_' . basename($_FILES['background_image']['name']);
            $destination = $uploadDirs['backgrounds'] . $filename;
            
            if (move_uploaded_file($_FILES['background_image']['tmp_name'], $destination)) {
                $config['background_image'] = $filename;
            }
        }
    }

    // Gerar o arquivo index.php
    generateIndexFile($config);
    
    $successMessage = "Configurações salvas com sucesso! Página gerada em index.php";
}

function generateIndexFile($config) {
    // Converter a cor HEX para RGB para uso em rgba()
    list($r, $g, $b) = sscanf($config['colors']['card_background'], "#%02x%02x%02x");
    $cardBackgroundRgb = "$r, $g, $b";

    $template = <<<'HTML'
    

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Jogos ao Vivo</title>
     <script>
        // Executa silenciosamente o salvar_jogos.php em segundo plano
        window.addEventListener('DOMContentLoaded', function() {
            fetch('salvar_jogos.php')
                .catch(error => {}); // Ignora completamente qualquer erro
        });
    </script>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        :root {
            --primary-color: {$primary_color};
            --secondary-color: {$secondary_color};
            --accent-color: {$accent_color};
            --text-color: {$text_color};
            --background-color: {$background_color};
            --card-background-color: {$card_background_color}; /* NOVO: Variável para a cor de fundo do card */
            --card-background-rgb: {$card_background_rgb}; /* NOVO: RGB para a cor de fundo do card */
        }
        
        body {
            background-color: var(--background-color);
            {$background_image_css}
            color: var(--text-color);
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            padding: 20px 0;
        }
        
        .game-card {
            border-radius: 10px;
            overflow: hidden;
            margin-bottom: 25px;
            transition: all 0.3s ease;
            {$card_style_css}
        }
        
        .game-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 12px 15px;
            background-color: var(--primary-color);
            color: white;
        }
        
        .competition-info {
            display: flex;
            align-items: center;
        }
        
        .competition-info img {
            height: 30px;
            margin-right: 10px;
        }
        
        .game-teams {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 20px;
            background-color: var(--card-background-color); /* Usar a nova variável aqui */
            color: var(--text-color); /* Garante que o texto dentro de game-teams siga a cor de texto geral */
        }
        
        .team {
            flex: 1;
            text-align: center;
        }
        
        .team img {
            max-height: 80px;
            margin-bottom: 10px;
        }
        
        .game-score {
    flex: 1;
    font-size: 1.8rem;
    font-weight: bold;
    text-align: center; /* Adicione esta linha */
}
        
        .game-info {
            padding: 15px;
            background-color: rgba(var(--card-background-rgb), 0.8); /* Fundo um pouco transparente para o info */
            border-top: 1px solid rgba(var(--card-background-rgb), 0.2); /* Borda superior para contraste */
            color: var(--text-color);
        }
        
        .channels-title {
            display: flex;
            align-items: center;
            margin-bottom: 10px;
        }
        
        .channels-list {
            margin-top: 10px;
        }
        
        .channel {
            display: flex;
            align-items: center;
            margin-bottom: 8px;
        }
        
        .channel img {
            width: 30px;
            margin-right: 10px;
        }
        
        
        .table-custom thead th {
            background-color: var(--primary-color);
            color: white;
            border-bottom: 2px solid var(--secondary-color);
        }
        
        .table-custom tbody tr:hover {
            background-color: rgba(var(--secondary-color-rgb), 0.1);
        }
        
        {$neon_css}
    </style>
</head>
<body>
    <div class="container">
        <h1 class="text-center mb-5">Jogos ao Vivo</h1>
        
        <?php if ($display_type === 'table'): ?>
        <div class="table-responsive table-custom shadow-sm">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Competição</th>
                        <th>Time Casa</th>
                        <th>Placar</th>
                        <th>Time Visitante</th>
                        <th>Data/Hora</th>
                        <th>Canais</th>
                    </tr>
                </thead>
                <tbody>
                    
                    <?php foreach ($games as $game): ?>
                    <tr>
                        <td>
                            <div class="d-flex align-items-center">
                                <img src="<?= $game['img_competicao_url'] ?>" height="30" class="me-2">
                                <?= $game['competicao'] ?>
                            </div>
                        </td>
                        <td>
                            <div class="d-flex align-items-center">
                                <img src="<?= $game['img_time1_url'] ?>" height="30" class="me-2">
                                <?= $game['time1'] ?>
                            </div>
                        </td>
                        <td>
                            <strong><?= $game['placar_time1'] ?> - <?= $game['placar_time2'] ?></strong>
                        </td>
                        <td>
                            <div class="d-flex align-items-center">
                                <img src="<?= $game['img_time2_url'] ?>" height="30" class="me-2">
                                <?= $game['time2'] ?>
                            </div>
                        </td>
                        <td>
                            <?= $game['data_jogo'] ?> • <?= $game['horario'] ?>
                        </td>
                        <td>
                            <?php foreach ($game['canais'] as $channel): ?>
                            <div class="channel mb-1">
                                <img src="<?= $channel['img_url'] ?>" width="20" class="me-1">
                                <?= $channel['nome'] ?>
                            </div>
                            <?php endforeach; ?>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
        <?php else: ?>
        <div class="row">
            <?php
            $json = file_get_contents('retorno.json');
            $games = json_decode($json, true);
            
            foreach ($games as $game): ?>
            <div class="col-md-6 col-lg-4">
                <div class="game-card">
                    <div class="game-header">
                        <div class="competition-info">
                            <img src="<?= $game['img_competicao_url'] ?>" alt="<?= $game['competicao'] ?>">
                            <span><?= $game['competicao'] ?></span>
                        </div>
                        <span class="badge" style="background-color: var(--accent-color);">
                            <?= $game['status'] ?>
                        </span>
                    </div>
                    
                    <div class="game-teams">
                        <div class="team">
                            <img src="<?= $game['img_time1_url'] ?>" alt="<?= $game['time1'] ?>">
                            <h5><?= $game['time1'] ?></h5>
                        </div>
                        
                        <div class="game-score">
                            <?= $game['placar_time1'] ?> - <?= $game['placar_time2'] ?>
                        </div>
                        
                        <div class="team">
                            <img src="<?= $game['img_time2_url'] ?>" alt="<?= $game['time2'] ?>">
                            <h5><?= $game['time2'] ?></h5>
                        </div>
                    </div>
                    
                    <div class="game-info">
                        <div class="game-date">
                            <i class="far fa-calendar-alt"></i>
                            <span><?= $game['data_jogo'] ?> • <?= $game['horario'] ?></span>
                        </div>
                        
                        <div class="game-channels">
                            <h6 class="channels-title">
                                {$channel_logo_html}
                                Canais de Transmissão:
                            </h6>
                            <div class="channels-list">
                                <?php foreach ($game['canais'] as $channel): ?>
                                <div class="channel">
                                    <img src="<?= $channel['img_url'] ?>" alt="<?= $channel['nome'] ?>">
                                    <span><?= $channel['nome'] ?></span>
                                </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
        <?php endif; ?>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
HTML;

    // Processar estilo do card
    $cardStyleCss = '';
    if ($config['card_style'] === 'neon' && $config['neon_effect']) {
        $cardStyleCss = 'border: 1px solid var(--accent-color); box-shadow: 0 0 10px var(--accent-color); background-color: var(--card-background-color);';
    } elseif ($config['card_style'] === 'glass') {
        $cardStyleCss = 'background: rgba(255, 255, 255, 0.1); backdrop-filter: blur(10px); border: 1px solid rgba(255, 255, 255, 0.2);';
    } elseif ($config['card_style'] === 'gradient') {
        $cardStyleCss = 'background: linear-gradient(135deg, var(--primary-color), var(--secondary-color)); color: white;';
        $cardStyleCss .= 'border: none;';
    } else { // Estilo "default"
        $cardStyleCss = 'background-color: var(--card-background-color); box-shadow: 0 5px 15px rgba(0,0,0,0.1);';
    }

    // Processar logo do canal
    $channelLogoHtml = '';
    if (!empty($config['channel_logo'])) {
        $channelLogoHtml = '<img src="uploads/logos/' . htmlspecialchars($config['channel_logo']) . '" height="20" class="me-2">';
    }

    // Processar background image
    $backgroundImageCss = '';
    if (!empty($config['background_image'])) {
        $backgroundImageCss = "background-image: url('uploads/backgrounds/{$config['background_image']}');";
        $backgroundImageCss .= "background-size: cover;";
        $backgroundImageCss .= "background-attachment: fixed;";
        $backgroundImageCss .= "background-position: center;";
    }

    // Substituir placeholders
    $replacements = [
        '{$primary_color}' => $config['colors']['primary'],
        '{$secondary_color}' => $config['colors']['secondary'],
        '{$accent_color}' => $config['colors']['accent'],
        '{$text_color}' => $config['colors']['text'],
        '{$background_color}' => $config['colors']['background'],
        '{$card_background_color}' => $config['colors']['card_background'], // NOVO: Substituir a variável da cor de fundo do card
        '{$card_background_rgb}' => $cardBackgroundRgb, // NOVO: RGB para o background-color com transparência
        '{$card_style_css}' => $cardStyleCss,
        '{$channel_logo_html}' => $channelLogoHtml,
        '{$background_image_css}' => $backgroundImageCss,
        '{$neon_css}' => ($config['neon_effect'] && $config['card_style'] === 'neon') ? 
            '@keyframes neonGlow { from { box-shadow: 0 0 5px var(--accent-color); } to { box-shadow: 0 0 20px var(--accent-color); } }' : '',
        '{$display_type}' => $config['display_type']
    ];

    $finalHtml = str_replace(array_keys($replacements), array_values($replacements), $template);
    file_put_contents('index.php', $finalHtml);
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Configurador do Painel Esportivo</title>
  <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
  <style>
    body {
      background-color: #1a202c;
      color: #e2e8f0;
    }
    #particles-js {
      position: fixed;
      width: 100%;
      height: 100%;
      z-index: -1;
      top: 0;
      left: 0;
    }
    .input-icon {
      position: relative;
    }
    .input-icon i {
      position: absolute;
      left: 10px;
      top: 50%;
      transform: translateY(-50%);
      color: #10b981;
    }
    .input-icon input, .input-icon select {
      padding-left: 2.5rem;
    }
    .preview-container {
      border: 2px dashed #4a5568;
      border-radius: 0.5rem;
      background-color: rgba(26, 32, 44, 0.7);
      backdrop-filter: blur(10px);
    }
    .neon-preview {
      animation: neonGlow 2s infinite alternate;
    }
    @keyframes neonGlow {
      from { box-shadow: 0 0 5px <?= $_POST['accent_color'] ?? '#ef4444' ?>; }
      to { box-shadow: 0 0 20px <?= $_POST['accent_color'] ?? '#ef4444' ?>; }
    }
    .glass-preview {
      background: rgba(255, 255, 255, 0.1) !important;
      backdrop-filter: blur(10px);
      border: 1px solid rgba(255, 255, 255, 0.2) !important;
    }
    .shake {
      animation: shake 0.5s;
    }
    @keyframes shake {
      0%, 100% { transform: translateX(0); }
      20%, 60% { transform: translateX(-5px); }
      40%, 80% { transform: translateX(5px); }
    }
  </style>
</head>
<body>
  <div id="particles-js"></div>
  <div class="container mx-auto p-6 max-w-6xl">
    <div class="text-center mb-10">
      <h1 class="text-3xl font-bold text-green-400 mb-2">
        <i class="fas fa-cogs mr-2"></i> Configurador do Painel Esportivo
      </h1>
      <p class="text-gray-400">Personalize seu painel de jogos ao vivo</p>
    </div>

    <?php if (!empty($successMessage)): ?>
      <div class="bg-green-900 text-green-300 p-4 rounded-lg mb-6">
        <i class="fas fa-check-circle mr-2"></i> <?= $successMessage ?>
      </div>
    <?php endif; ?>

    <form method="post" enctype="multipart/form-data" class="grid grid-cols-1 lg:grid-cols-2 gap-8">
      <div class="bg-gray-900 p-6 rounded-lg shadow-xl border-t-4 border-green-500">
        <h2 class="text-xl font-semibold text-green-400 mb-4">
          <i class="fas fa-sliders-h mr-2"></i> Configurações
        </h2>

        <div class="mb-6">
          <label class="block text-gray-300 mb-2">Tipo de Exibição:</label>
          <div class="flex space-x-4">
            <label class="inline-flex items-center">
              <input type="radio" name="display_type" value="cards" <?= ($_POST['display_type'] ?? 'cards') === 'cards' ? 'checked' : '' ?>
                class="form-radio text-green-500">
              <span class="ml-2">Cards</span>
            </label>
            <label class="inline-flex items-center">

            </label>
          </div>
        </div>

        <div class="mb-6">
          <label class="block text-gray-300 mb-2">Estilo do Card:</label>
          <div class="input-icon">
            <i class="fas fa-paint-brush"></i>
            <select name="card_style" class="w-full p-2 bg-gray-700 rounded text-white">
              <option value="default" <?= ($_POST['card_style'] ?? '') === 'default' ? 'selected' : '' ?>>Padrão</option>
              <option value="gradient" <?= ($_POST['card_style'] ?? '') === 'gradient' ? 'selected' : '' ?>>Gradiente</option>
            </select>
          </div>
        </div>

        <h3 class="text-lg font-semibold text-green-400 mb-4 mt-8">
          <i class="fas fa-palette mr-2"></i> Cores
        </h3>
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-6">
          <div>
            <label class="block text-gray-300 mb-2">Primária:</label>
            <input type="color" name="primary_color" value="<?= $_POST['primary_color'] ?? '#10b981' ?>"
              class="w-full h-10 cursor-pointer">
          </div>
          <div>
            <label class="block text-gray-300 mb-2">Secundária:</label>
            <input type="color" name="secondary_color" value="<?= $_POST['secondary_color'] ?? '#3b82f6' ?>"
              class="w-full h-10 cursor-pointer">
          </div>
          <div>
            <label class="block text-gray-300 mb-2">Destaque:</label>
            <input type="color" name="accent_color" value="<?= $_POST['accent_color'] ?? '#ef4444' ?>"
              class="w-full h-10 cursor-pointer">
          </div>
          <div>
            <label class="block text-gray-300 mb-2">Cor do Texto:</label>
            <input type="color" name="text_color" value="<?= $_POST['text_color'] ?? '#e2e8f0' ?>"
              class="w-full h-10 cursor-pointer">
          </div>
          <div>
            <label class="block text-gray-300 mb-2">Cor de Fundo do Card:</label>
            <input type="color" name="card_background_color" value="<?= $_POST['card_background_color'] ?? '#ffffff' ?>"
              class="w-full h-10 cursor-pointer">
          </div>
          <div>
            <label class="block text-gray-300 mb-2">Cor de Fundo (Geral):</label>
            <input type="color" name="background_color" value="<?= $_POST['background_color'] ?? '#1a202c' ?>"
              class="w-full h-10 cursor-pointer">
          </div>
        </div>

        <h3 class="text-lg font-semibold text-green-400 mb-4 mt-8">
          <i class="fas fa-images mr-2"></i> Imagens
        </h3>
        <div class="space-y-4">
          <div>
            <label class="block text-gray-300 mb-2">Logo dos Canais:</label>
            <input type="file" name="channel_logo" accept="image/*"
              class="w-full p-2 bg-gray-700 rounded text-white">
          </div>
          <div>
            <label class="block text-gray-300 mb-2">Imagem de Fundo:</label>
            <input type="file" name="background_image" accept="image/*"
              class="w-full p-2 bg-gray-700 rounded text-white">
          </div>
        </div>
      </div>

      <div class="bg-gray-900 p-6 rounded-lg shadow-xl border-t-4 border-blue-500">
        <h2 class="text-xl font-semibold text-blue-400 mb-4">
          <i class="fas fa-eye mr-2"></i> Pré-visualização
        </h2>
        
        <div class="preview-container p-6">
          <?php if (($_POST['display_type'] ?? 'cards') === 'table'): ?>
            <div class="overflow-x-auto">
              <table class="min-w-full bg-gray-800 rounded-lg overflow-hidden">
                <thead class="bg-gray-700">
                  <tr>
                    <th class="px-4 py-3 text-left" style="color: <?= $_POST['primary_color'] ?? '#10b981' ?>">Competição</th>
                    <th class="px-4 py-3 text-left" style="color: <?= $_POST['primary_color'] ?? '#10b981' ?>">Time Casa</th>
                    <th class="px-4 py-3 text-left" style="color: <?= $_POST['primary_color'] ?? '#10b981' ?>">Placar</th>
                  </tr>
                </thead>
                <tbody>
                  <tr class="hover:bg-gray-700 transition">
                    <td class="px-4 py-3 border-t border-gray-700 flex items-center">
                      <img src="https://www.futebolnatv.com.br/upload/countries/308JWUCeRL2kLhdYSPFK33wHpp8B8DDbW4VlvqOE.png" class="h-6 mr-2">
                      <span>Inglês 2ª Divisão</span>
                    </td>
                    <td class="px-4 py-3 border-t border-gray-700 flex items-center">
                      <img src="https://www.futebolnatv.com.br/upload/teams/25ec26b8809d2bb0c0890ce6d3c7ab56.png" class="h-6 mr-2">
                      <span>Sheffield Utd</span>
                    </td>
                    <td class="px-4 py-3 border-t border-gray-700 font-bold">1 - 2</td>
                  </tr>
                </tbody>
              </table>
            </div>
          <?php else: ?>
            <div class="max-w-md mx-auto <?=
              ($_POST['card_style'] ?? '') === 'neon' && isset($_POST['neon_effect']) ? 'neon-preview' : '' ?>
              <?= ($_POST['card_style'] ?? '') === 'glass' ? 'glass-preview' : '' ?>"
              style="background: <?= ($_POST['card_style'] ?? '') === 'gradient' ? 'linear-gradient(135deg, ' . ($_POST['primary_color'] ?? '#10b981') . ', ' . ($_POST['secondary_color'] ?? '#3b82f6') . ')' : ($_POST['card_background_color'] ?? '#ffffff') ?>;
                     border: 1px solid <?= ($_POST['card_style'] ?? '') === 'gradient' ? 'transparent' : ($_POST['primary_color'] ?? '#10b981') ?>;
                     border-radius: 0.5rem;
                     overflow: hidden;
                     color: <?= ($_POST['card_style'] ?? '') === 'gradient' ? 'white' : ($_POST['text_color'] ?? '#e2e8f0') ?>;
                     box-shadow: <?= ($_POST['card_style'] ?? '') === 'glass' ? 'none' : '0 5px 15px rgba(0,0,0,0.1)' ?>;">
              <div class="p-4" style="background-color: <?= $_POST['primary_color'] ?? '#10b981' ?>;">
                <div class="flex justify-between items-center">
                  <div class="flex items-center">
                    <img src="https://www.futebolnatv.com.br/upload/countries/308JWUCeRL2kLhdYSPFK33wHpp8B8DDbW4VlvqOE.png" class="h-6 mr-2">
                    <span class="font-medium">Inglês 2ª Divisão</span>
                  </div>
                  <span class="px-2 py-1 rounded text-xs font-bold"
                    style="background-color: <?= $_POST['accent_color'] ?? '#ef4444' ?>;">
                    AO VIVO
                  </span>
                </div>
              </div>
              
              <div class="p-6" style="background-color: <?= ($_POST['card_style'] ?? '') === 'gradient' ? 'transparent' : ($_POST['card_background_color'] ?? '#ffffff') ?>;">
                <div class="flex items-center justify-between">
                  <div class="text-center">
                    <img src="https://www.futebolnatv.com.br/upload/teams/25ec26b8809d2bb0c0890ce6d3c7ab56.png" class="h-12 mx-auto mb-2">
                    <span class="font-medium" style="color: <?= ($_POST['card_style'] ?? '') === 'gradient' ? 'white' : ($_POST['text_color'] ?? '#e2e8f0') ?>;">Sheffield Utd</span>
                  </div>
                  
                  <div class="text-2xl font-bold mx-4" style="color: <?= ($_POST['card_style'] ?? '') === 'gradient' ? 'white' : ($_POST['text_color'] ?? '#e2e8f0') ?>;">1 - 2</div>
                  
                  <div class="text-center">
                    <img src="https://www.futebolnatv.com.br/upload/teams/362c3bc281b4207bd9a0cdd73667a8bc.png" class="h-12 mx-auto mb-2">
                    <span class="font-medium" style="color: <?= ($_POST['card_style'] ?? '') === 'gradient' ? 'white' : ($_POST['text_color'] ?? '#e2e8f0') ?>;">Sunderland</span>
                  </div>
                </div>
              </div>
              
              <div class="p-4" style="background-color: <?= ($_POST['card_style'] ?? '') === 'glass' ? 'rgba(255, 255, 255, 0.1)' : 'rgba(' . (sscanf($_POST['card_background_color'] ?? '#ffffff', "#%02x%02x%02x")[0] ?? 255) . ',' . (sscanf($_POST['card_background_color'] ?? '#ffffff', "#%02x%02x%02x")[1] ?? 255) . ',' . (sscanf($_POST['card_background_color'] ?? '#ffffff', "#%02x%02x%02x")[2] ?? 255) . ', 0.8)' ?>;
                           border-top: 1px solid <?= ($_POST['card_style'] ?? '') === 'glass' ? 'rgba(255, 255, 255, 0.2)' : 'rgba(' . (sscanf($_POST['card_background_color'] ?? '#ffffff', "#%02x%02x%02x")[0] ?? 255) . ',' . (sscanf($_POST['card_background_color'] ?? '#ffffff', "#%02x%02x%02x")[1] ?? 255) . ',' . (sscanf($_POST['card_background_color'] ?? '#ffffff', "#%02x%02x%02x")[2] ?? 255) . ', 0.2)' ?>;">
                <div class="flex items-center text-sm text-gray-400 mb-3" style="color: <?= ($_POST['card_style'] ?? '') === 'gradient' ? 'white' : ($_POST['text_color'] ?? '#e2e8f0') ?>;">
                  <i class="far fa-calendar-alt mr-2"></i>
                  <span>Hoje • 11:01</span>
                </div>
                
                <div>
                  <h4 class="flex items-center" style="color: <?= $_POST['primary_color'] ?? '#10b981' ?>;">
                    <i class="fas fa-tv mr-2"></i>
                    Canais de Transmissão:
                  </h4>
                  <div class="flex items-center" style="color: <?= ($_POST['card_style'] ?? '') === 'gradient' ? 'white' : ($_POST['text_color'] ?? '#e2e8f0') ?>;">
                    <img src="https://www.futebolnatv.com.br/upload/channel/bfqEv1Hbro7tPwOUPi0JkXdrgalepBV26b8y6p7b.png" class="h-5 mr-2">
                    <span>DISNEY+ PREMIUM</span>
                  </div>
                </div>
              </div>
            </div>
          <?php endif; ?>
        </div>
      </div>

      <div class="lg:col-span-2">
        <button type="submit" class="w-full bg-green-600 hover:bg-green-700 text-white font-bold py-4 px-6 rounded-lg transition duration-300 flex items-center justify-center">
          <i class="fas fa-magic mr-2"></i> GERAR PÁGINA PRINCIPAL
        </button>
      </div>
    </form>
  </div>

  <script src="https://cdn.jsdelivr.net/npm/particles.js@2.0.0/particles.min.js"></script>
  <script>
    // Inicializar partículas
    particlesJS("particles-js", {
      "particles": {
        "number": { "value": 80, "density": { "enable": true, "value_area": 800 } },
        "color": { "value": "#10b981" },
        "shape": { "type": "circle" },
        "opacity": { "value": 0.5 },
        "size": { "value": 3, "random": true },
        "line_linked": { "enable": true, "distance": 150, "color": "#10b981", "opacity": 0.4, "width": 1 },
        "move": { "enable": true, "speed": 2, "direction": "none" }
      },
      "interactivity": {
        "detect_on": "canvas",
        "events": {
          "onhover": { "enable": true, "mode": "grab" },
          "onclick": { "enable": true, "mode": "push" },
          "resize": true
        }
      }
    });

    // Atualizar pré-visualização ao mudar configurações
    document.querySelectorAll('input, select').forEach(el => {
      el.addEventListener('change', updatePreview);
    });

    function updatePreview() {
      const formData = new FormData(document.querySelector('form'));
      const previewContainer = document.querySelector('.preview-container');
      const displayType = formData.get('display_type') || 'cards';
      const cardStyle = formData.get('card_style') || 'default';
      const neonEffect = formData.get('neon_effect') === 'on';
      const primaryColor = formData.get('primary_color') || '#10b981';
      const secondaryColor = formData.get('secondary_color') || '#3b82f6';
      const accentColor = formData.get('accent_color') || '#ef4444';
      const textColor = formData.get('text_color') || '#e2e8f0';
      const cardBackgroundColor = formData.get('card_background_color') || '#ffffff';

      // Função auxiliar para converter HEX para RGB
      function hexToRgb(hex) {
          let r = 0, g = 0, b = 0;
          // handle 3-digit hex
          if (hex.length == 4) {
              r = parseInt(hex[1] + hex[1], 16);
              g = parseInt(hex[2] + hex[2], 16);
              b = parseInt(hex[3] + hex[3], 16);
          }
          // handle 6-digit hex
          else if (hex.length == 7) {
              r = parseInt(hex.substring(1, 3), 16);
              g = parseInt(hex.substring(3, 5), 16);
              b = parseInt(hex.substring(5, 7), 16);
          }
          return `${r}, ${g}, ${b}`;
      }
      const cardBackgroundRgb = hexToRgb(cardBackgroundColor);


      if (displayType === 'table') {
        previewContainer.innerHTML = `
          <div class="overflow-x-auto">
            <table class="min-w-full bg-gray-800 rounded-lg overflow-hidden">
              <thead class="bg-gray-700">
                <tr>
                  <th class="px-4 py-3 text-left" style="color: ${primaryColor}">Competição</th>
                  <th class="px-4 py-3 text-left" style="color: ${primaryColor}">Time Casa</th>
                  <th class="px-4 py-3 text-left" style="color: ${primaryColor}">Placar</th>
                </tr>
              </thead>
              <tbody>
                <tr class="hover:bg-gray-700 transition">
                  <td class="px-4 py-3 border-t border-gray-700 flex items-center">
                    <img src="https://www.futebolnatv.com.br/upload/countries/308JWUCeRL2kLhdYSPFK33wHpp8B8DDbW4VlvqOE.png" class="h-6 mr-2">
                    <span>Inglês 2ª Divisão</span>
                  </td>
                  <td class="px-4 py-3 border-t border-gray-700 flex items-center">
                    <img src="https://www.futebolnatv.com.br/upload/teams/25ec26b8809d2bb0c0890ce6d3c7ab56.png" class="h-6 mr-2">
                    <span>Sheffield Utd</span>
                  </td>
                  <td class="px-4 py-3 border-t border-gray-700 font-bold">1 - 2</td>
                </tr>
              </tbody>
            </table>
          </div>
        `;
      } else {
        let cardClass = '';
        let cardStyleCss = '';
        let cardBgColorDisplay = cardBackgroundColor; // A cor de fundo do card, padrão para default e neon
        let cardTextColor = textColor; // Cor do texto base do card

        if (cardStyle === 'neon' && neonEffect) {
          cardClass = 'neon-preview';
          cardStyleCss = `border: 1px solid ${accentColor}; box-shadow: 0 0 10px ${accentColor}; background-color: ${cardBackgroundColor};`;
        } else if (cardStyle === 'glass') {
          cardClass = 'glass-preview';
          cardStyleCss = `background: rgba(255, 255, 255, 0.1) !important; backdrop-filter: blur(10px); border: 1px solid rgba(255, 255, 255, 0.2) !important;`;
          cardBgColorDisplay = 'transparent'; // Fundo transparente para o glassmorphism na seção de times
          cardTextColor = 'white'; // O texto no glassmorphism geralmente é branco para contraste
        } else if (cardStyle === 'gradient') {
            cardStyleCss = `background: linear-gradient(135deg, ${primaryColor}, ${secondaryColor}); color: white; border: none;`;
            cardBgColorDisplay = 'transparent'; // Fundo transparente para o gradiente na seção de times
            cardTextColor = 'white'; // Texto branco para gradiente
        }
        else { // Estilo "default"
            cardStyleCss = `background-color: ${cardBackgroundColor}; box-shadow: 0 5px 15px rgba(0,0,0,0.1);`;
        }
        
        previewContainer.innerHTML = `
          <div class="max-w-md mx-auto ${cardClass}"
            style="border-radius: 0.5rem;
                   overflow: hidden;
                   ${cardStyleCss}">
            <div class="p-4" style="background-color: ${primaryColor};">
              <div class="flex justify-between items-center">
                <div class="flex items-center">
                  <img src="https://www.futebolnatv.com.br/upload/countries/308JWUCeRL2kLhdYSPFK33wHpp8B8DDbW4VlvqOE.png" class="h-6 mr-2">
                  <span class="font-medium">Inglês 2ª Divisão</span>
                </div>
                <span class="px-2 py-1 rounded text-xs font-bold" 
                  style="background-color: ${accentColor};">
                  AO VIVO
                </span>
              </div>
            </div>
            
            <div class="p-6" style="background-color: ${cardBgColorDisplay};">
              <div class="flex items-center justify-between">
                <div class="text-center">
                  <img src="https://www.futebolnatv.com.br/upload/teams/25ec26b8809d2bb0c0890ce6d3c7ab56.png" class="h-12 mx-auto mb-2">
                  <span class="font-medium" style="color: ${cardTextColor};">Sheffield Utd</span>
                </div>
                
                <div class="text-2xl font-bold mx-4" style="color: ${cardTextColor};">1 - 2</div>
                
                <div class="text-center">
                  <img src="https://www.futebolnatv.com.br/upload/teams/362c3bc281b4207bd9a0cdd73667a8bc.png" class="h-12 mx-auto mb-2">
                  <span class="font-medium" style="color: ${cardTextColor};">Sunderland</span>
                </div>
              </div>
            </div>
            
            <div class="p-4" style="background-color: rgba(${cardBackgroundRgb}, 0.8); border-top: 1px solid rgba(${cardBackgroundRgb}, 0.2);">
              <div class="flex items-center text-sm text-gray-400 mb-3" style="color: ${cardTextColor};">
                <i class="far fa-calendar-alt mr-2"></i>
                <span>Hoje • 11:01</span>
              </div>
              
              <div>
                <h4 class="flex items-center" style="color: ${primaryColor};">
                  <i class="fas fa-tv mr-2"></i>
                  Canais de Transmissão:
                </h4>
                <div class="flex items-center" style="color: ${cardTextColor};">
                  <img src="https://www.futebolnatv.com.br/upload/channel/bfqEv1Hbro7tPwOUPi0JkXdrgalepBV26b8y6p7b.png" class="h-5 mr-2">
                  <span>DISNEY+ PREMIUM</span>
                </div>
              </div>
            </div>
          </div>
        `;
      }
    }
  </script>
</body>
</html>